<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-person me-2"></i>Kelola Biodata / CV
    </h2>
</div>

<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle me-2"></i><?= session()->getFlashdata('success') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="bi bi-exclamation-triangle me-2"></i><?= session()->getFlashdata('error') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('info')): ?>
    <div class="alert alert-info alert-dismissible fade show" role="alert">
        <i class="bi bi-info-circle me-2"></i><?= session()->getFlashdata('info') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<!-- Info Card -->
<div class="admin-card">
    <div class="alert alert-info mb-0">
        <i class="bi bi-info-circle me-2"></i>
        <strong>Informasi:</strong> Halaman ini untuk mengelola biodata/CV portfolio personal Anda. 
        Jika biodata sudah ada, Anda akan diarahkan ke halaman edit. Jika belum ada, silakan buat biodata terlebih dahulu.
    </div>
</div>

<!-- Redirect akan dilakukan oleh controller -->
<div class="admin-card text-center py-5">
    <div class="spinner-border text-primary" role="status">
        <span class="visually-hidden">Loading...</span>
    </div>
    <p class="mt-3 text-white">Mengarahkan...</p>
</div>

<script>
    // Redirect otomatis setelah 1 detik
    setTimeout(function() {
        window.location.href = '<?= base_url('admin/biodata/edit') ?>';
    }, 1000);
</script>
<?= $this->endSection() ?>
